<?php
include("templates/headers/inc.php");

// If we have a session, redirect !
if($_SESSION && isset($_SESSION["USER_ID"])) {
	header("Location: home.php");
	exit;
}

// Include the JS file
$js_files = array();

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','allow_fb')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$allow_fb = $config_array["allow_fb"];

$fb_enabled = false;

if(FB_APP_ID != "" && FB_APP_SECRET != "") {
	// Initialize FB SDK
	$fb = new \Facebook\Facebook([
		'app_id' => FB_APP_ID,
		'app_secret' => FB_APP_SECRET,
		'default_graph_version' => 'v2.3'
	]);	
	
	$helper = $fb->getRedirectLoginHelper();
	
	// Get FB Login URL
	$permissions = ['email']; // Optional permissions
	$loginUrl = $helper->getLoginUrl(URL . "/fb-login.php", $permissions);
	
	$fb_enabled = true;
}

$username = "";
$email = "";
$error = "";

// Manage Post 
if($_POST) {
	
	if(isset($_POST["email"]) && isset($_POST["password"])) {
	
		$email = $_POST["email"];
		$password = $_POST["password"];
		
		if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			
			$error = "You need to specify a valid email address.";
			
		} else if(strlen($password) < 4) {
			
			$error = "You need to specify a password with at last 4 characters.";
			
		} else {
			
			$password = sha1($password);
			
			$check_user_sql = $dbh->prepare("SELECT id, fullname, email, profile_picture, rank FROM user WHERE email = :email AND password = :password");
			$check_user_sql->bindParam(":email", $email);
			$check_user_sql->bindParam(":password", $password);
			$check_user_sql->execute();
			
			if($check_user_sql->rowCount() == 0) {
				
				$error = "Wrong email or / and password.";
				
			} else {
			
				$user = $check_user_sql->fetch();
				$user_id = $user["id"];
				$email = $user["email"];
				$fullname = $user["fullname"];
				$profile_picture = $user["profile_picture"];
				$rank = $user["rank"];
				
				
				// Open session
				$_SESSION["USER_ID"] = $user_id;
				$_SESSION["EMAIL"] = $email;
				$_SESSION["FULL_NAME"] = $fullname;
				$_SESSION["PROFILE_PICTURE"] = $profile_picture;
				$_SESSION["RANK"] = $rank;
					
				if($_COOKIE && isset($_COOKIE["redirect_quiz_id"])) {
					
					$quiz_id = $_COOKIE["redirect_quiz_id"];
					
					// Delete the cookie...
					unset($_COOKIE['redirect_quiz_id']);
					setcookie('redirect_quiz_id', null, -1, '/');
					
					if($new_user) {
						$stmt = $dbh->prepare("	UPDATE user
												SET 
												origin = 'quiz'
												WHERE id = :user_id
												");
											
						$stmt->bindParam(':user_id', $user_id);
						$stmt->execute();
					}
					
					// Redirect..
					header("Location: " . URL . "/quiz.php?id=" . $quiz_id);
					
				} else {
					
					if($new_user) {
						$stmt = $dbh->prepare("	UPDATE user
												SET 
												origin = 'home'
												WHERE id = :user_id
												");
											
						$stmt->bindParam(':user_id', $user_id);
						$stmt->execute();
					
						// Redirects
						header("Location: create-quiz.php?action=$action");
					} else {
						// Redirects
						header("Location: home.php?action=$action");
					}
					
				}
			}
		}
	
	}
	
}

// -- Include the header template
include("templates/headers/unlogged_header.php");
?>

<div class="row">
	
	<div class="login-block col-md-6 offset-md-3">
		<h3>Start Here</h3>
		<small>Create your Funny Quiz</small>
		<?php
		if($allow_fb == 1) {
		?>
		<a href="<?php echo $loginUrl; ?>" class="btn-login-fb"><img src="img/fb-login.png" alt="Login with Facebook" /></a>
		<div class="or_separator">
        	OR
        </div>
        <?php
		}
		?>
        <div class="row row_sign_up <?php if($allow_fb == 0 && $fb_enabled) { ?>no_fb_login<?php } ?>">
															
			<div class="col-md-8 offset-md-2 d-flex align-items-center">
				<form class="user" action="" method="POST">
					<?php
					if(TEST_MODE) {
					?>
					<div class="alert alert-info" style="font-size: 13px;">
						<h3 style="margin-bottom: 5px;">Demo Login</h3>
						Just click on <b>Sign In</b> to log-in to the demo account.
					</div>
					<?php
					}	
					?>
					<?php
					if($error != "") {
					?>
					<div class="alert alert-danger alert-center">
						
						<?php echo $error; ?>
						
					</div>
					<?php
					}	
					?>									
				    <div class="form-group row">
				        <div class="col-sm-6 mb-3 mb-sm-0">
				            <input type="text" class="form-control form-control-user" placeholder="Email" name="email" value="<?php if(TEST_MODE) { ?>admin@demo.com<?php } ?>">
				        </div>
				        <div class="col-sm-6">										            
					        <input type="password" class="form-control form-control-user" placeholder="Password" name="password" value="<?php if(TEST_MODE) { ?>admin<?php } ?>">

				        </div>
				    </div>
				    <button type="submit" class="btn btn-primary btn-user btn-block">
				    Sign In
				    </button>
				    <div class="no_account_sign_up">
				    	Don't have an account? <a href="sign-up.php">Sign Up</a>
				    </div>
				</form>
			</div>
			
		</div>
		
	</div>
	
</div>

	
<div class="container-features">
	<div class="block_feature">
		<div class="row d-flex align-items-center">
		
			<div class="col-md-6 block_icon">
				<img src="img/funny_icon.png" />
			</div>
			
			<div class="col-md-6 block-text right">
				<h3>Make Funny Quiz</h3>
				<p>Create a quiz with the awesome quiz creator with questions about you or about anything else in just a few minutes.</p>
			</div>
			
		</div>
		
	</div>
</div>

<div class="row row-arrow">

	<div class="col-md-12">
		<img src="img/lightening_icon.png">
	</div>

</div>

<div class="container-features">
	<div class="block_feature">
		<div class="row d-flex align-items-center">
			
			<div class="col-md-6 block-text left">
				<h3>Share with your Friends</h3>
				<p>Share it on Facebook or other social networks to see how much your friends know you!</p>
			</div>
		
			<div class="col-md-6 block_icon">
				<img src="img/friends_icon.png" />
			</div>
			
		</div>
		
	</div>
</div>

<div class="row row-arrow">

	<div class="col-md-12">
		<img src="img/lightening_icon.png">
	</div>

</div>

<div class="container-features">
	<div class="block_feature">
		<div class="row d-flex align-items-center">
		
			<div class="col-md-6 block_icon">
				<img src="img/share_icon.png" />
			</div>
			
			<div class="col-md-6 block-text right">
				<h3>Discover Results</h3>
				<p>Easily list the friends that know you the most and help them discover you with as many quiz as you want.</p>
			</div>
			
		</div>
		
	</div>
</div>
<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>